using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgEditMinimumReaction
	/// </summary>
	public class DlgEditMinimumReaction : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label lblReagentType;
		private System.Windows.Forms.Label lblTestWith;
		private System.Windows.Forms.Label lblReactions;
		private System.Windows.Forms.TextBox txtReagentType;
		private System.Windows.Forms.TextBox txtTestWith;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReactions;
		private System.ComponentModel.IContainer components = null;
		private BOL.ReagentType _reagentType;
		System.Collections.ArrayList _expectedMinReactions = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="reagentType"></param>
		public DlgEditMinimumReaction(ref BOL.ReagentType reagentType)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			this._reagentType = reagentType;
			this._reagentType.Invalid += new System.EventHandler(OnInvalid);
			this._reagentType.Valid += new System.EventHandler(OnValid);
			PopulateForm();
			SetComponentProperties();
		}

		private void PopulateForm()
		{
			//Populate the list view with the appropriate data
			if(_reagentType.SetVialId == String.Empty)
			{
				txtReagentType.Text =this._reagentType.ReagentTypeName;
			}
			else
			{
				txtReagentType.Text =this._reagentType.ReagentTypeName + " " + _reagentType.SetVialId;
			}
			
			txtTestWith.Text = this._reagentType.TestWithName;
			_expectedMinReactions = BOL.ReagentType.GetCanChangeExpectedMinReactions();
			cmbReactions.Items.AddRange(BOL.ReagentType.GetCanChangeExpectedMinReactions().ToArray());
			cmbReactions.Text = this._reagentType.ExpectedMinimumReactionTestResultText;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgEditMinimumReaction));
			this.lblReagentType = new System.Windows.Forms.Label();
			this.lblTestWith = new System.Windows.Forms.Label();
			this.lblReactions = new System.Windows.Forms.Label();
			this.txtReagentType = new System.Windows.Forms.TextBox();
			this.txtTestWith = new System.Windows.Forms.TextBox();
			this.cmbReactions = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.grpImage.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(432, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Edit Minimum Reaction";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 169);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// lblReagentType
			// 
			this.lblReagentType.Location = new System.Drawing.Point(8, 20);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(148, 20);
			this.lblReagentType.TabIndex = 0;
			this.lblReagentType.Text = "Reagent Type";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTestWith
			// 
			this.lblTestWith.Location = new System.Drawing.Point(8, 48);
			this.lblTestWith.Name = "lblTestWith";
			this.lblTestWith.Size = new System.Drawing.Size(148, 20);
			this.lblTestWith.TabIndex = 2;
			this.lblTestWith.Text = "Test With";
			this.lblTestWith.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblReactions
			// 
			this.lblReactions.Location = new System.Drawing.Point(8, 76);
			this.lblReactions.Name = "lblReactions";
			this.lblReactions.Size = new System.Drawing.Size(160, 20);
			this.lblReactions.TabIndex = 4;
			this.lblReactions.Text = "Expected Minimum Reactions*";
			this.lblReactions.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReagentType
			// 
			this.txtReagentType.AccessibleDescription = "Reagent Type";
			this.txtReagentType.AccessibleName = "Reagent Type";
			this.txtReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentType.Location = new System.Drawing.Point(156, 20);
			this.txtReagentType.Name = "txtReagentType";
			this.txtReagentType.ReadOnly = true;
			this.txtReagentType.Size = new System.Drawing.Size(196, 20);
			this.txtReagentType.TabIndex = 1;
			this.txtReagentType.Text = "";
			// 
			// txtTestWith
			// 
			this.txtTestWith.AccessibleDescription = "Test With";
			this.txtTestWith.AccessibleName = "Test With";
			this.txtTestWith.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTestWith.Location = new System.Drawing.Point(156, 48);
			this.txtTestWith.Name = "txtTestWith";
			this.txtTestWith.ReadOnly = true;
			this.txtTestWith.Size = new System.Drawing.Size(196, 20);
			this.txtTestWith.TabIndex = 3;
			this.txtTestWith.Text = "";
			// 
			// cmbReactions
			// 
			this.cmbReactions.AccessibleDescription = "Expected Minimum Reactions";
			this.cmbReactions.AccessibleName = "Expected Minimum Reactions";
			this.cmbReactions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbReactions.Interval = 100;
			this.cmbReactions.Location = new System.Drawing.Point(156, 76);
			this.cmbReactions.MaxLength = 11;
			this.cmbReactions.Name = "cmbReactions";
			this.cmbReactions.Size = new System.Drawing.Size(84, 22);
			this.cmbReactions.TabIndex = 5;
			this.cmbReactions.SelectedIndexChanged += new System.EventHandler(this.cmbReactions_SelectedIndexChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(268, 156);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 6;
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(348, 156);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 7;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 112);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 44);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.txtReagentType);
			this.groupBox1.Controls.Add(this.txtTestWith);
			this.groupBox1.Controls.Add(this.lblReagentType);
			this.groupBox1.Controls.Add(this.cmbReactions);
			this.groupBox1.Controls.Add(this.lblReactions);
			this.groupBox1.Controls.Add(this.lblTestWith);
			this.groupBox1.Location = new System.Drawing.Point(60, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(364, 112);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			// 
			// DlgEditMinimumReaction
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(432, 185);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.groupBox1);
			this.hlphelpChm.SetHelpKeyword(this, "Configure_Daily_QC.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "DlgEditMinimumReaction";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Edit Minimum Reaction";
			this.Load += new System.EventHandler(this.DlgEditMinimumReaction_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgEditMinimumReaction_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgEditMinimumReaction_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Edit Minimum Reaction";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC051.DlgEditMinimumReaction());
			//
			this.cmbReactions.Interval = 100;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
		}

		private void cmbReactions_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(this._reagentType.ExpectedMinimumReactionTestResultText != cmbReactions.Text)
			{
				this.btnOK.EnabledButton = true;
			}
			if(_expectedMinReactions.Contains(cmbReactions.Text))
			{
				this._reagentType.ExpectedMinimumReactionTestResultText = cmbReactions.Text;
				this._reagentType.ExpectedMinimumReaction = cmbReactions.Text.Replace("+","").Trim();
			}
			else
			{
				this._reagentType.ExpectedMinimumReaction = string.Empty;
			}
		}

		private void DlgEditMinimumReaction_Load(object sender, System.EventArgs e)
		{
			this._reagentType.SetInitialBrokenRules(this.Name);
		}

		/// <summary>
		/// Disables the OK button if the object is not valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnInvalid(object sender, System.EventArgs e)
		{			
			btnOK.EnabledButton = false;
		}

		/// <summary>
		/// Enables the OK button if the object is valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			if(this.IsDirty)
			{
				btnOK.EnabledButton = true;
			}
			btnOK.SetToolTip("");
		}

		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			this.btnOK.SetToolTip(this._reagentType.GetBrokenRulesMessage(this.Name));
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this._reagentType = null;
		}
	}
}

